import {IBaseJournalFetchParams} from 'reducers/journal/types';
import {EContentPageMode} from 'projects/journal/types/EContentPageMode';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getTagsListActions} from 'reducers/journal/actions';

import {journalDeviceSelector} from 'selectors/journal/journalDeviceSelector';

import {templatorService} from 'serviceProvider';

export function fetchTags({
    req,
    branch,
    isPreview,
}: IBaseJournalFetchParams): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            const device = journalDeviceSelector(getState());

            dispatch(getTagsListActions.request());
            dispatch(
                getTagsListActions.success(
                    await templatorService
                        .provider(req?.container)
                        .getTagsList({
                            device,
                            ds: branch,
                            templator_content: isPreview
                                ? EContentPageMode.PREVIEW
                                : undefined,
                        }),
                ),
            );
        } catch (error) {
            dispatch(getTagsListActions.failure());
        }
    };
}
