import {combineReducers} from 'redux';
import {enableBatching} from 'redux-batched-actions';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';
import {getResetStateReducer} from 'reducers/utils/resetState/reducer';

import commonReducer from './common/rootReducer';
import hotelsReducer from './hotels/rootReducer';
import hotelsExtranetReducer from './hotelsExtranet/rootReducer';
import accountReducer from './account/rootReducer';
import aviaReducer from './avia/reducer';
import trainsReducer from './trains/rootReducer';
import busesReducer from './buses';
import tripsReducer from './trips/reducer';
import toursReducer from './tours/reducer';
import testControlPanelReducer from './testControlPanel/reducer';

const rootReducer = () =>
    getResetStateReducer(
        enableBatching(
            combineReducers({
                common: commonReducer,
                hotels: hotelsReducer,
                hotelsExtranet: hotelsExtranetReducer,
                account: accountReducer,
                avia: aviaReducer,
                trains: trainsReducer,
                buses: busesReducer,
                happyPage: loadableReducer(ELoadableReducer.HAPPY_PAGE),
                favorites: loadableReducer(ELoadableReducer.HOTELS_FAVORITES),
                trips: tripsReducer,
                tours: toursReducer,
                journal: loadableReducer(ELoadableReducer.JOURNAL),
                testControlPanel: testControlPanelReducer,
            }),
        ),
    );

export type TRootReducerType = typeof rootReducer;

export default rootReducer;
