import {IBusesStore} from 'reducers/buses/types/IBusesStore';
import {IHappyPageStore} from 'reducers/happyPage/types/IHappyPageStore';

import {ITrains} from 'reducers/trains/trainsReducerTypes';
import {
    TCommonAction,
    ICommonReducer,
} from 'reducers/common/commonReducerTypes';
import {TrainsAction} from 'reducers/trains/actions';
import {TAviaActions} from 'reducers/avia/reducer';
import {IAccountReducerProps} from 'reducers/account/reducerProps';
import {IHotelsStore} from 'reducers/hotels/IHotelsStore';
import {IHotelsExtranetStore} from 'reducers/hotelsExtranet/IHotelsExtranetStore';
import {IAviaStore} from 'reducers/avia/IAviaStore';
import ITripsState from 'reducers/trips/ITripsState';
import {IJournalState} from 'reducers/journal/reducer';
import IToursState from 'reducers/tours/IToursState';
import {ITestControlPanelState} from 'reducers/testControlPanel/reducer';

import {IFavoritesInfoState} from './favorites/reducer';

export type ProjectAction = TrainsAction | TAviaActions | TCommonAction;

export interface StoreInterface {
    common: ICommonReducer;
    hotels: IHotelsStore;
    hotelsExtranet: IHotelsExtranetStore;
    account: IAccountReducerProps;
    avia: IAviaStore;
    trains: ITrains;
    buses: IBusesStore;
    happyPage: IHappyPageStore;
    favorites: IFavoritesInfoState;
    trips: ITripsState;
    journal: IJournalState;
    tours: IToursState;
    testControlPanel: ITestControlPanelState;
}
