import {ActionType, createAction} from 'typesafe-actions';

import {
    IToursSearchFormFromPointField,
    IToursSearchFormToPointField,
} from 'projects/index/IndexApp/components/IndexTours/components/SearchForm/types';

export const setToursSearchFormFromFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_FROM',
)<IToursSearchFormFromPointField>();
export const setToursSearchFormToFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_TO',
)<IToursSearchFormToPointField>();
export const setToursSearchFormStartDateFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_START_DATE',
)<string | null>();
export const setToursSearchFormFlexibleNightsAction = createAction(
    'TOURS.SEARCH_FORM.SET_FLEXIBLE_NIGHTS',
)<boolean>();
export const setToursSearchFormAdultsFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_ADULTS',
)<number>();
export const setToursSearchFormFlexibleDatesAction = createAction(
    'TOURS.SEARCH_FORM.SET_FLEXIBLE_DATES',
)<boolean>();
export const setToursSearchFormNightsFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_NIGHTS',
)<number | string>();
export const setToursSearchFormChildrenAgesFieldAction = createAction(
    'TOURS.SEARCH_FORM.SET_CHILDREN_AGES',
)<number[]>();

const reducerActions = {
    setToursSearchFormFromFieldAction,
    setToursSearchFormToFieldAction,
    setToursSearchFormStartDateFieldAction,
    setToursSearchFormFlexibleDatesAction,
    setToursSearchFormFlexibleNightsAction,
    setToursSearchFormNightsFieldAction,
    setToursSearchFormAdultsFieldAction,
    setToursSearchFormChildrenAgesFieldAction,
};

export type TToursSearchFormActions = ActionType<typeof reducerActions>;
