import {createReducer} from 'typesafe-actions';

import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_CHILDREN_AGES,
    DEFAULT_NIGHTS_COUNT,
} from 'constants/tours';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IToursSearchFormValues} from 'projects/index/IndexApp/components/IndexTours/components/SearchForm/types';

import {
    setToursSearchFormAdultsFieldAction,
    setToursSearchFormChildrenAgesFieldAction,
    setToursSearchFormFlexibleDatesAction,
    setToursSearchFormFlexibleNightsAction,
    setToursSearchFormFromFieldAction,
    setToursSearchFormNightsFieldAction,
    setToursSearchFormStartDateFieldAction,
    setToursSearchFormToFieldAction,
    TToursSearchFormActions,
} from 'reducers/tours/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

const initialState: IToursSearchFormValues = {
    [ESearchFormFieldName.FROM]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.TO]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.START_DATE]: null,
    flexibleDates: false,
    flexibleNights: false,
    nightsCount: DEFAULT_NIGHTS_COUNT,
    adults: DEFAULT_ADULTS_COUNT,
    childrenAges: DEFAULT_CHILDREN_AGES,
};

export default createReducer<IToursSearchFormValues, TToursSearchFormActions>(
    initialState,
)
    .handleAction(setToursSearchFormFromFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.FROM]: payload,
    }))
    .handleAction(setToursSearchFormToFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.TO]: payload,
    }))
    .handleAction(
        setToursSearchFormStartDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.START_DATE]: payload,
            flexibleDates: payload ? state.flexibleDates : false,
        }),
    )
    .handleAction(
        setToursSearchFormFlexibleDatesAction,
        (state, {payload}) => ({
            ...state,
            flexibleDates: payload,
        }),
    )
    .handleAction(
        setToursSearchFormFlexibleNightsAction,
        (state, {payload}) => ({
            ...state,
            flexibleNights: payload,
        }),
    )
    .handleAction(setToursSearchFormNightsFieldAction, (state, {payload}) => ({
        ...state,
        nightsCount:
            typeof payload === 'string'
                ? Number.parseInt(payload, 10)
                : payload,
    }))
    .handleAction(setToursSearchFormAdultsFieldAction, (state, {payload}) => ({
        ...state,
        adults: payload,
    }))
    .handleAction(
        setToursSearchFormChildrenAgesFieldAction,
        (state, {payload}) => ({
            ...state,
            childrenAges: payload,
        }),
    );
