import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {
    ICountrySuggestActionRequestParams,
    IDeparturesSuggestActionRequestParams,
} from 'types/tours/suggests/IDepartureSuggest';
import {TDeparture} from 'server/api/LevelTravelApi/types';
import {
    IToursSuggestDeparture,
    IToursSuggestDestination,
} from 'projects/index/IndexApp/components/IndexTours/components/SearchForm/types';

export const getSearchSuggestsDepartureActions = createAsyncAction(
    'TOURS.SEARCH_SUGGESTS_DEPARTURE.REQUEST',
    'TOURS.SEARCH_SUGGESTS_DEPARTURE.REQUEST_SUCCESS',
    'TOURS.SEARCH_SUGGESTS_DEPARTURE.REQUEST_FAILURE',
)<
    {
        fieldType: ESearchFormFieldName.FROM;
        requestParams: IDeparturesSuggestActionRequestParams;
    },
    {
        fieldType: ESearchFormFieldName.FROM;
        items: IToursSuggestDeparture[];
    },
    {
        fieldType: ESearchFormFieldName.FROM;
    }
>();

export const getSearchSuggestsDestinationActions = createAsyncAction(
    'TOURS.SEARCH_SUGGESTS_DESTINATION.REQUEST',
    'TOURS.SEARCH_SUGGESTS_DESTINATION.REQUEST_SUCCESS',
    'TOURS.SEARCH_SUGGESTS_DESTINATION.REQUEST_FAILURE',
)<
    {
        fieldType: ESearchFormFieldName.TO;
        requestParams: ICountrySuggestActionRequestParams;
    },
    {
        fieldType: ESearchFormFieldName.TO;
        items: IToursSuggestDestination[];
    },
    {
        fieldType: ESearchFormFieldName.TO;
    }
>();

export const setDepartures = createAction(
    'TOURS.SEARCH_SUGGEST.SET_DEPARTURES',
)<TDeparture[]>();

const reducerActions = {
    getSearchSuggestsDepartureActions,
    getSearchSuggestsDestinationActions,
    setDepartures,
};

export type TToursSearchSuggestsActions = ActionType<typeof reducerActions>;
