import {createReducer} from 'typesafe-actions';

import {TAsyncStore} from 'reducers/types/TAsyncStore';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {
    ICountrySuggest,
    ICountrySuggestActionRequestParams,
    IDeparturesSuggestActionRequestParams,
    IDepartureSuggest,
} from 'types/tours/suggests/IDepartureSuggest';
import {TDeparture} from 'server/api/LevelTravelApi/types';
import {IToursSuggestDeparture} from 'projects/index/IndexApp/components/IndexTours/components/SearchForm/types';

import {
    getSearchSuggestsDepartureActions,
    getSearchSuggestsDestinationActions,
    setDepartures,
    TToursSearchSuggestsActions,
} from 'reducers/tours/searchSuggests/actions';

export interface ISearchSuggestsState {
    [ESearchFormFieldName.FROM]: TAsyncStore<
        IDepartureSuggest,
        IDeparturesSuggestActionRequestParams
    >;
    [ESearchFormFieldName.TO]: TAsyncStore<
        ICountrySuggest,
        ICountrySuggestActionRequestParams
    >;
    departures: TDeparture[];
}

const defaultDepartureFieldValue: TAsyncStore<
    IToursSuggestDeparture[],
    IDeparturesSuggestActionRequestParams
> = {
    value: null,
    isLoading: false,
    isNotFound: false,
    requestParams: null,
    isFailed: false,
    isFetched: false,
};

const defaultDestinationFieldValue: TAsyncStore<
    ICountrySuggest,
    ICountrySuggestActionRequestParams
> = {
    value: null,
    isLoading: false,
    isNotFound: false,
    requestParams: null,
    isFailed: false,
    isFetched: false,
};

const INITIAL_STATE = {
    [ESearchFormFieldName.FROM]: defaultDepartureFieldValue,
    [ESearchFormFieldName.TO]: defaultDestinationFieldValue,
    departures: [],
};

export default createReducer<ISearchSuggestsState, TToursSearchSuggestsActions>(
    INITIAL_STATE,
)
    .handleAction(
        [
            getSearchSuggestsDepartureActions.request,
            getSearchSuggestsDestinationActions.request,
        ],
        (state, {payload: {fieldType, requestParams}}) => ({
            ...state,
            [fieldType]: {
                // Оставляем предыдущее значение, чтобы саджесты не "мигали"
                value: state[fieldType].value,
                requestParams,
                isLoading: true,
                isFetched: false,
                isFailed: false,
                isNotFound: false,
            },
        }),
    )
    .handleAction(
        [
            getSearchSuggestsDepartureActions.success,
            getSearchSuggestsDestinationActions.success,
        ],
        (state, {payload}) => {
            return {
                ...state,
                [payload.fieldType]: {
                    ...state[payload.fieldType],
                    value: payload.items,
                    isLoading: false,
                    isFetched: true,
                },
            };
        },
    )
    .handleAction(
        [
            getSearchSuggestsDepartureActions.failure,
            getSearchSuggestsDestinationActions.failure,
        ],
        (state, {payload}) => ({
            ...state,
            [payload.fieldType]: {
                ...state[payload.fieldType],
                value: null,
                isLoading: false,
                isFetched: true,
                isFailed: true,
            },
        }),
    )
    .handleAction(setDepartures, (state, {payload}) => ({
        ...state,
        departures: payload,
    }));
