import {createReducer} from 'typesafe-actions';

import {
    TWidgetInfoActionsTypes,
    getWidgetInfo,
} from 'reducers/tours/widgetInfo/actions';

export interface IWidgetInfoState {
    label: string | null;
    isLoading: boolean;
    isError: boolean;
}

const initialState: IWidgetInfoState = {
    label: null,
    isLoading: false,
    isError: false,
};

export default createReducer<IWidgetInfoState, TWidgetInfoActionsTypes>(
    initialState,
)
    .handleAction(getWidgetInfo.request, state => {
        return {...state, isLoading: true, isError: false};
    })
    .handleAction(getWidgetInfo.success, (state, action) => {
        return {
            ...state,
            label: action.payload,
            isLoading: false,
            isError: false,
        };
    })
    .handleAction(getWidgetInfo.failure, () => {
        return {label: null, isLoading: false, isError: true};
    });
