import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getWidgetInfo} from 'reducers/tours/widgetInfo/actions';

import {logError} from 'utilities/logger/logError';

import {tours} from 'serviceProvider/tours/toursProvider/toursProvider';

export function fetchWidgetInfo(req?: Request): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getWidgetInfo.request());

            const res = await tours
                .provider(req?.container)
                .getToursWidgetInfo();

            dispatch(getWidgetInfo.success(res.label));
        } catch (e) {
            dispatch(getWidgetInfo.failure());
            logError(
                {
                    message: 'levelTravelError: failed to recieve label',
                },
                e,
            );
        }
    };
}
