import {batchActions} from 'redux-batched-actions';

import {ITrainsCoach} from 'reducers/trains/order/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    clearPlaces,
    clearRequirements,
    setCoach,
    setPreferredGender,
    setExpandedServiceClass,
} from 'reducers/trains/order/actions/trains';

import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

import getCoachClassKey from 'projects/trains/lib/order/getCoachClassKey';

/*
 * Меняем вагон и сбрасываем все требования к местам
 */
export function changeCoachAndResetRequirements(
    coach: ITrainsCoach | null,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const currentDirectionAndIndex =
            currentSegmentDirectionAndIndexSelector(state);
        const serviceClassKey = coach ? getCoachClassKey({coach}) : null;

        dispatch(
            batchActions([
                setCoach({...currentDirectionAndIndex, data: coach}),
                setPreferredGender({...currentDirectionAndIndex, data: null}),
                clearPlaces({...currentDirectionAndIndex, data: undefined}),
                clearRequirements({
                    ...currentDirectionAndIndex,
                    data: undefined,
                }),
                setExpandedServiceClass({
                    ...currentDirectionAndIndex,
                    data: serviceClassKey,
                }),
            ]),
        );
    };
}
