import {LANG} from 'constants/langCodes';
import {ETrainsPartner} from 'projects/trains/constants/trainPartners';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setTrainsPartner} from 'reducers/trains/common/actions';

import {IDependencies} from 'server/getContainerConfig';

import {trainsService} from 'serviceProvider';

export const updatePurchaseAvailability =
    (container?: IDependencies): CustomThunkAction<void> =>
    async dispatch => {
        try {
            const partnerCodes = await trainsService
                .provider(container)
                .activePartners({language: LANG.RU});
            const partner =
                partnerCodes.find(code => code === ETrainsPartner.IM) ||
                partnerCodes.find(code => code === ETrainsPartner.UFS) ||
                null;

            dispatch(setTrainsPartner(partner));
        } catch (err) {}
    };
