import {getType} from 'typesafe-actions';

import {TrainsSearchContextType} from 'reducers/trains/context/types';

import {
    resetTrainsContext,
    setTrainsContext,
} from 'reducers/trains/context/actions';
import {ProjectAction} from 'reducers/storeTypes';

export const defaultState: TrainsSearchContextType = {
    from: null,
    to: null,
    when: null,
    originalWhen: null,
    returnWhen: null,
    distance: null,
    errors: null,
    latestDatetime: null,
    isChanged: false,
    original: null,
    direction: null,
    forwardSegmentId: null,
    backwardSegmentId: null,
};

export default function context(
    state: TrainsSearchContextType = defaultState,
    action: ProjectAction,
): TrainsSearchContextType {
    switch (action.type) {
        case getType(setTrainsContext):
            return action.payload;

        case getType(resetTrainsContext):
            return {...defaultState};

        default:
            return state;
    }
}
