import {createReducer, ActionType} from 'typesafe-actions';

import {ITrainsCrossLinks} from 'reducers/trains/direction/crossLinks/types';

import * as actions from 'reducers/trains/direction/crossLinks/actions';

const initialState: ITrainsCrossLinks = {
    trains: {
        params: null,
        data: [],
    },
};

export default createReducer<ITrainsCrossLinks, ActionType<typeof actions>>(
    initialState,
)
    .handleAction(
        actions.trainsFetchCrossLinksAsyncAction.request,
        (state, {payload}) => ({
            ...state,
            trains: {
                params: payload,
                data: [],
            },
        }),
    )
    .handleAction(
        actions.trainsFetchCrossLinksAsyncAction.success,
        (state, {payload}) => ({
            ...state,
            trains: {
                ...state.trains,
                data: payload,
            },
        }),
    )
    .handleAction(actions.trainsFetchCrossLinksAsyncAction.failure, state => ({
        ...state,
        trains: {
            params: null,
            data: [],
        },
    }));
