import _isEqual from 'lodash/isEqual';

import {Request} from '@yandex-data-ui/core/lib/types';
import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';
import {ITrainsCrossLinksParams} from 'reducers/trains/direction/crossLinks/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {trainsFetchCrossLinksAsyncAction} from 'reducers/trains/direction/crossLinks/actions';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {trainsCrossLinksParamsSelector} from 'selectors/trains/direction/trainsCrossLinksSelector';

import {trainsSearchProvider} from 'serviceProvider';

/**
 * Изоморфный экшен загружает и записывает в стор перекрестные направления.
 */
export default function fetchTrainsCrossLinks({
    params,
    req,
}: {
    params: ITrainsCrossLinksParams;
    req?: Request;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const state = getState();
        const context = trainsContextSelector(state);
        const prevParams = trainsCrossLinksParamsSelector(state);

        if (
            _isEqual(prevParams, params) ||
            !isFilledTrainsSearchContext(context)
        ) {
            return;
        }

        try {
            dispatch(trainsFetchCrossLinksAsyncAction.request(params));

            const {crossLinks} = await trainsSearchProvider
                .provider(req?.container)
                .getCrossLinks({
                    fromKey: context.from.key,
                    toKey: context.to.key,
                });

            dispatch(trainsFetchCrossLinksAsyncAction.success(crossLinks));
        } catch (error) {
            dispatch(trainsFetchCrossLinksAsyncAction.failure());
        }
    };
}
