import {ActionType, createReducer} from 'typesafe-actions';

import {ITrainsReviews} from 'reducers/trains/direction/reviews/types';

import * as actions from 'reducers/trains/direction/reviews/actions';

const initialState: ITrainsReviews = {
    params: null,
    items: [],
};

export default createReducer<ITrainsReviews, ActionType<typeof actions>>(
    initialState,
)
    .handleAction(
        actions.fetchTrainsReviewsAsyncAction.request,
        (state, {payload}) => ({
            params: payload,
            items: [],
        }),
    )
    .handleAction(
        actions.fetchTrainsReviewsAsyncAction.success,
        (state, {payload}) => ({
            ...state,
            items: payload,
        }),
    )
    .handleAction(actions.fetchTrainsReviewsAsyncAction.failure, () => ({
        params: null,
        items: [],
    }));
