import _isEqual from 'lodash/isEqual';

import {Request} from '@yandex-data-ui/core/lib/types';
import {IReviewsGetTrainsReviewsApiParams} from 'server/api/ReviewsApi/types/IReviewsGetTrainsReviewsApiParams';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {fetchTrainsReviewsAsyncAction} from 'reducers/trains/direction/reviews/actions';

import {trainsReviewsParamsSelector} from 'selectors/trains/direction/trainsReviewsSelector';

import {reviewsProvider} from 'serviceProvider/reviews/reviewsProvider';

/**
 * Изоморфный экшен загружает и записывает в стор отзывы пользователей о поездах по данному направлению.
 */
export default function fetchReviews({
    params,
    req,
}: {
    params: IReviewsGetTrainsReviewsApiParams;
    req?: Request;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const prevParams = trainsReviewsParamsSelector(getState());

        if (_isEqual(prevParams, params)) {
            return;
        }

        try {
            dispatch(fetchTrainsReviewsAsyncAction.request(params));
            dispatch(
                fetchTrainsReviewsAsyncAction.success(
                    await reviewsProvider
                        .provider(req?.container)
                        .getTrainsReviews(params),
                ),
            );
        } catch (error) {
            dispatch(fetchTrainsReviewsAsyncAction.failure());
        }
    };
}
