import {ActionType, createAsyncAction} from 'typesafe-actions';

import {
    ITrainsGetDirectionSearchApiResponse,
    ITrainsGetDirectionSearchApiParams,
} from 'server/api/TrainsSearchApi/types/ITrainsGetDirectionSearch';

export const getDirectionSearchActions = createAsyncAction(
    'TRAIN.DIRECTION_SEARCH_PAGE.REQUEST',
    'TRAIN.DIRECTION_SEARCH_PAGE.REQUEST_SUCCESS',
    'TRAIN.DIRECTION_SEARCH_PAGE.REQUEST_FAILURE',
)<
    ITrainsGetDirectionSearchApiParams,
    ITrainsGetDirectionSearchApiResponse,
    undefined
>();

export type TTrainsGetDirectionSearchActions = ActionType<
    typeof getDirectionSearchActions
>;
