import {createReducer} from 'typesafe-actions';

import {TTrainsDirectionSearch} from 'reducers/trains/direction/search/types';

import {
    getDirectionSearchActions,
    TTrainsGetDirectionSearchActions,
} from 'reducers/trains/direction/search/actions';

const INITIAL_STATE: TTrainsDirectionSearch = {
    value: null,
    requestParams: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    isNotFound: false,
};

export default createReducer<
    TTrainsDirectionSearch,
    TTrainsGetDirectionSearchActions
>(INITIAL_STATE)
    .handleAction(getDirectionSearchActions.request, (state, {payload}) => ({
        ...state,
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getDirectionSearchActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getDirectionSearchActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
