import {isEqual} from 'lodash';

import {Request} from '@yandex-data-ui/core/lib/types';
import {ITrainsGetDirectionSearchApiParams} from 'server/api/TrainsSearchApi/types/ITrainsGetDirectionSearch';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getDirectionSearchActions} from 'reducers/trains/direction/search/actions';

import {directionSearchSelector} from 'selectors/trains/direction/searchSelector';

import {logError} from 'utilities/logger/logError';

import {trainsService} from 'serviceProvider';

export default function requestDirectionSearchInfoAction({
    req,
    params,
    withRefreshIfErrors,
}: {
    req?: Request;
    params: ITrainsGetDirectionSearchApiParams;
    withRefreshIfErrors?: boolean;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const prevDirectionSearch = directionSearchSelector(getState());
        const {requestParams: prevRequestParams} = prevDirectionSearch;

        if (
            prevRequestParams &&
            isEqual(prevRequestParams, params) &&
            (!withRefreshIfErrors || !prevDirectionSearch.isFailed)
        ) {
            return;
        }

        try {
            dispatch(getDirectionSearchActions.request(params));

            const directionSearchInfo = await trainsService
                .provider(req?.container)
                .getDirectionSearch(params);

            dispatch(getDirectionSearchActions.success(directionSearchInfo));
        } catch (err) {
            dispatch(getDirectionSearchActions.failure());

            logError(
                {
                    message:
                        '[YATRAVEL][TRAINS] Запрос данных ручки направления',
                },
                err,
            );
        }
    };
}
