import {ITrainsGetDirectionSearchApiParams} from 'server/api/TrainsSearchApi/types/ITrainsGetDirectionSearch';
import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import trainsParseContext from 'reducers/trains/context/actions/trainsParseContext';
import requestDirectionSearchInfoAction from 'reducers/trains/direction/search/thunk/requestDirectionSearchInfoAction';
import {fillFormFromContextThunkAction} from 'reducers/trains/searchForm/thunk/fillFormFromContextThunkAction';
import {getDirectionSearchActions} from 'reducers/trains/direction/search/actions';
import fetchTrainsCrossLinks from 'reducers/trains/direction/crossLinks/thunk/fetchTrainsCrossLinks';
import {setTrainsContext} from 'reducers/trains/context/actions';
import {setTrainsSearchFormStartDateFieldAction} from 'reducers/trains/searchForm/actions';
import fetchReviews from 'reducers/trains/direction/reviews/thunk/fetchReviews';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';

import {logError} from 'utilities/logger/logError';
import {logWarning} from 'utilities/logger/logWarning';

export default function requestDirectionSearchPageAction({
    req,
    params,
    withRefreshIfErrors,
}: {
    req?: Request;
    params: ITrainsGetDirectionSearchApiParams;
    withRefreshIfErrors?: boolean;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        try {
            await Promise.all([
                (async (): Promise<void> => {
                    const {fromSlug, toSlug} = params;

                    const prevContext = trainsContextSelector(getState());

                    if (
                        prevContext.from?.slug === fromSlug &&
                        prevContext.to?.slug === toSlug &&
                        (!withRefreshIfErrors || !prevContext.errors?.length)
                    ) {
                        if (prevContext.when) {
                            dispatch(
                                setTrainsContext({
                                    ...prevContext,
                                    when: null,
                                    originalWhen: null,
                                }),
                            );

                            dispatch(
                                setTrainsSearchFormStartDateFieldAction(null),
                            );
                        }
                    } else {
                        await dispatch(
                            trainsParseContext(
                                {
                                    from: {
                                        slug: fromSlug,
                                    },
                                    to: {
                                        slug: toSlug,
                                    },
                                },
                                req?.container,
                            ),
                        );
                    }

                    try {
                        dispatch(
                            fetchTrainsCrossLinks({
                                params: {fromSlug, toSlug},
                                req,
                            }),
                        );
                    } catch (err) {
                        logWarning(
                            {
                                message:
                                    '[YATRAVEL][TRAINS] Не смогли получить данные по кросслинкам',
                            },
                            err,
                        );
                    }

                    dispatch(fillFormFromContextThunkAction());
                })(),
                dispatch(
                    requestDirectionSearchInfoAction({
                        req,
                        params,
                        withRefreshIfErrors,
                    }),
                ),
                dispatch(fetchReviews({params, req})),
            ]);
        } catch (err) {
            dispatch(getDirectionSearchActions.failure());

            logError(
                {
                    message:
                        '[YATRAVEL][TRAINS] Запрос данных для страницы направления',
                },
                err,
            );
        }
    };
}
