import {createReducer} from 'typesafe-actions';

import {TTrainsFirmTrainStore} from 'reducers/trains/firmTrain/types';

import {
    getFirmTrainActions,
    TTrainsGetFirmTrainActions,
} from 'reducers/trains/firmTrain/actions';

const INITIAL_STATE: TTrainsFirmTrainStore = {
    value: null,
    requestParams: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    isNotFound: false,
};

export default createReducer<TTrainsFirmTrainStore, TTrainsGetFirmTrainActions>(
    INITIAL_STATE,
)
    .handleAction(getFirmTrainActions.request, (state, {payload}) => ({
        ...state,
        value: null,
        requestParams: payload,
        isLoading: true,
        isFetched: false,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getFirmTrainActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        isFailed: false,
        isNotFound: false,
    }))
    .handleAction(getFirmTrainActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        isNotFound: false,
    }));
