import {isEqual} from 'lodash';

import {Request} from '@yandex-data-ui/core/lib/types';
import {ITrainsGetFirmTrainServiceParams} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainServiceParams';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getFirmTrainActions} from 'reducers/trains/firmTrain/actions';

import requestFirmTrain from 'projects/trains/lib/api/requestFirmTrain';

export default function requestFirmTrainThunkAction({
    req,
    params,
}: {
    req?: Request;
    params: ITrainsGetFirmTrainServiceParams;
}): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const {
            trains: {firmTrain: prevFirmTrain},
        } = getState();

        const {requestParams: prevRequestParams} = prevFirmTrain;

        if (prevRequestParams && isEqual(prevRequestParams, params)) {
            return;
        }

        try {
            dispatch(getFirmTrainActions.request(params));

            const firmTrainInfo = await requestFirmTrain({
                req,
                params,
            });

            dispatch(getFirmTrainActions.success(firmTrainInfo));
        } catch (err) {
            dispatch(getFirmTrainActions.failure());
        }
    };
}
