import {createAction, ActionType} from 'typesafe-actions';

import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';

import {ETrainsSearchFiltersActionTypes} from './actionTypes';

/* Actions */
export const setTrainsSearchFilterValue = createAction(
    ETrainsSearchFiltersActionTypes.SET_FILTER,
)<TTrainsFilterTypeAndValue>();

export const resetAllTrainsSearchFilterValues = createAction(
    ETrainsSearchFiltersActionTypes.RESET_FILTERS,
)<void>();

export const fillTrainsSearchFilters = createAction(
    ETrainsSearchFiltersActionTypes.FILL_FILTERS,
)<ITrainsFilters>();

/* Action Types */
export type TSetTrainsSearchFilterValueAction =
    typeof setTrainsSearchFilterValue;
export type TFillTrainsSearchFiltersAction = typeof fillTrainsSearchFilters;
export type TFillTrainsSearchFiltersActionType = ActionType<
    typeof fillTrainsSearchFilters
>;
export type TResetAllTrainsSearchFiltersAction =
    typeof resetAllTrainsSearchFilterValues;

export type TTrainsSearchFiltersActions = ActionType<
    | TSetTrainsSearchFilterValueAction
    | TFillTrainsSearchFiltersAction
    | TResetAllTrainsSearchFiltersAction
>;
