import {createReducer} from 'typesafe-actions';

import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {prepareTrainsFilterValueBeforeSaveToState} from 'projects/trains/lib/genericSearch/filters/prepareTrainsFilterValueBeforeSaveToState';
import {getFiltersWithDefaultValues} from 'projects/trains/lib/genericSearch/filters/getFiltersWithDefaultValues';

import {
    setTrainsSearchFilterValue,
    fillTrainsSearchFilters,
    resetAllTrainsSearchFilterValues,
    TTrainsSearchFiltersActions,
} from './actions';

export type TTrainsSearchFiltersReducer = ITrainsFilters | null;

/* Initial State */
const initialState: TTrainsSearchFiltersReducer = null;

/* Reducer */
const trainsSearchFiltersReducer = createReducer<
    TTrainsSearchFiltersReducer,
    TTrainsSearchFiltersActions
>(initialState)
    .handleAction(
        setTrainsSearchFilterValue,
        (state, action): TTrainsSearchFiltersReducer => {
            const {payload} = action;
            const {type} = payload;

            if (!state) {
                return state;
            }

            return {
                ...state,
                [type]: {
                    ...state[type],
                    value: prepareTrainsFilterValueBeforeSaveToState({
                        filter: state[type],
                        typeAndValue: payload,
                    }),
                },
            };
        },
    )
    .handleAction(
        resetAllTrainsSearchFilterValues,
        (state): TTrainsSearchFiltersReducer => {
            const filtersWithDefaultValues = getFiltersWithDefaultValues({
                filters: state,
            });

            if (!filtersWithDefaultValues) {
                return state;
            }

            return {
                ...state,
                ...filtersWithDefaultValues,
            };
        },
    )
    .handleAction(
        fillTrainsSearchFilters,
        (state, action): TTrainsSearchFiltersReducer => {
            return action.payload;
        },
    );

export default trainsSearchFiltersReducer;
