import {
    createAsyncAction,
    createAction,
    ActionType,
    PayloadAction,
} from 'typesafe-actions';

import {ITrainsSearchInfoResponse} from 'server/api/TrainsSearchApi/types/ITrainsSearch';
import {ITrainsSearchErrorActionPayload} from './types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {ETrainsSearchActionTypes} from './actionTypes';

/* Start Polling  */
export const trainsSearchActions = createAsyncAction(
    ETrainsSearchActionTypes.START_SEARCH,
    ETrainsSearchActionTypes.SUCCESS_SEARCH,
    ETrainsSearchActionTypes.FAILED_SEARCH,
)<
    ITrainsFilledSearchContext | undefined,
    ITrainsSearchInfoResponse,
    ITrainsSearchErrorActionPayload
>();

/* Stop Polling  */
export const stopTrainsSearch = createAction(
    ETrainsSearchActionTypes.STOP_SEARCH,
)<undefined>();

/* Clear result */
export const clearTrainsSearchResult = createAction(
    ETrainsSearchActionTypes.CLEAR_SEARCH_RESULT,
)<undefined>();

/* Action Types */
export type TTrainsSearchPollingAsyncAction = ActionType<
    typeof trainsSearchActions
>;

export type TTrainsSearchPollingSuccessActionType = PayloadAction<
    ETrainsSearchActionTypes.SUCCESS_SEARCH,
    ITrainsSearchInfoResponse
>;

export type TStartTrainsSearchAction = () => void;
export type TStopTrainsSearchAction = typeof stopTrainsSearch;
export type TClearTrainsSearchResultAction = typeof clearTrainsSearchResult;

export type TTrainsSearchActions =
    | TTrainsSearchPollingAsyncAction
    | ActionType<TStopTrainsSearchAction | TClearTrainsSearchResultAction>;
