import {createReducer} from 'typesafe-actions';

import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import {
    EQueryingStatus,
    ITrainsSearchInfo,
} from 'types/trains/search/searchInfo/ITrainsSearchInfo';

import {
    clearTrainsSearchResult,
    trainsSearchActions,
    TTrainsSearchActions,
} from './actions';

export interface ITrainsSearchReducer extends ITrainsSearchInfo {
    errorCode?: ESearchErrorTypes;
}

/* Initial State */
const initialState: ITrainsSearchReducer = {
    status: EQueryingStatus.QUERYING,
    variants: [],
};

/* Reducer */
const trainsSearchReducer = createReducer<
    ITrainsSearchReducer,
    TTrainsSearchActions
>(initialState)
    .handleAction(
        trainsSearchActions.request,
        (): ITrainsSearchReducer => ({
            variants: [],
            status: EQueryingStatus.QUERYING,
        }),
    )
    .handleAction(
        trainsSearchActions.success,
        (state, {payload}): ITrainsSearchReducer => {
            const {status, variants, context, nearestTrainDatesByDirection} =
                payload;

            return {
                status,
                context,
                variants,
                nearestTrainDatesByDirection,
            };
        },
    )
    .handleAction(
        trainsSearchActions.failure,
        (state, {payload}): ITrainsSearchReducer => ({
            errorCode: payload.errorCode,
            status: EQueryingStatus.DONE,
            variants: [],
        }),
    )
    .handleAction(
        clearTrainsSearchResult,
        (): ITrainsSearchReducer => initialState,
    );

export default trainsSearchReducer;
