import {isActionOf, getType} from 'typesafe-actions';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import {ProjectAction} from 'reducers/storeTypes';
import {StoredTrainAction} from 'reducers/trains/trainsReducerTypes';
import {
    setOrderCreated,
    setOrderPageStatus,
} from 'reducers/trains/order/actions/flow';
import {
    addPlacesToOrder,
    clearPlaces,
    removePlacesFromOrder,
    setCoach,
    setOrderCoachType,
    setPlaces,
    setPreferredGender,
} from 'reducers/trains/order/actions/trains';

const DEFAULT_STATE: StoredTrainAction[] = [];

export default function userActions(
    state = DEFAULT_STATE,
    action: ProjectAction,
) {
    if (
        isActionOf(
            [
                setCoach,
                setPlaces,
                clearPlaces,
                setOrderCreated,
                addPlacesToOrder,
                setOrderCoachType,
                setPreferredGender,
                setOrderPageStatus,
                removePlacesFromOrder,
            ],
            action,
        )
    ) {
        let data: any = 'payload' in action ? action.payload : null;

        if (action.type === getType(setCoach)) {
            data = action.payload?.data?.number ?? null;
        } else if (
            action.type === getType(setOrderPageStatus) &&
            action.payload === ORDER_PAGE_STATUSES.READY_TO_INTERACTION
        ) {
            data = action.meta.url;
        }

        return [
            ...state,
            {
                type: action.type,
                data,
            },
        ];
    }

    return state;
}
