import {createAction} from 'typesafe-actions';

import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

interface IBonusCardPayload {
    type: TRAIN_BONUS_CARDS;
    number?: string;
}

export const setBonusCard = createAction(
    'trains/order/setBonusCard',
    (payload: IBonusCardPayload, _meta: number) => ({
        ...payload,
        number: payload.number?.trim(),
    }),
    (payload: IBonusCardPayload, meta: number) => meta,
)();
