/* global __CLIENT__ */
import {createAction} from 'typesafe-actions';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

export const setOrderCreated = createAction(
    'trains/order/setOrderCreated',
)<string>();
export const startOrder = createAction('trains/order/startOrder')();
export const cancelOrder = createAction('trains/order/cancelOrder')();
export const cancelOrderPolling = createAction(
    'trains/order/cancelOrderPolling',
)();
export const resumeOrderPolling = createAction(
    'trains/order/resumeOrderPolling',
)();
export const setOrderPageStatus = createAction(
    'trains/order/setOrderPageStatus',
    (payload: ORDER_PAGE_STATUSES) => payload,
    () => {
        const meta: {url: string} = {url: ''};

        if (__CLIENT__) {
            meta.url = window.location.href;
        }

        return meta;
    },
)();
export const setPaymentCompleted = createAction(
    'trains/order/setPaymentCompleted',
)<boolean>();
export const setPaymentCalled = createAction(
    'trains/order/setPaymentCalled',
)<boolean>();
