import {createAction} from 'typesafe-actions';

import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

export const setDocumentType = createAction('trains/order/setDocumentType')<
    TRAINS_DOCUMENT_TYPES,
    number
>();

export const setDocumentNumber = createAction(
    'trains/order/setDocumentNumber',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setDocumentCountry = createAction(
    'trains/order/setDocumentCountry',
)<number | undefined, number>();

export const setDocumentValidDate = createAction(
    'trains/order/setDocumentValidDate',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();
