import {createAction} from 'typesafe-actions';

import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

export const setGender = createAction('trains/order/setGender')<
    GENDER_TYPE,
    number
>();

export const setAgeGroup = createAction('trains/order/setAgeGroup')<
    PASSENGERS_TYPES,
    number
>();

export const setLastName = createAction(
    'trains/order/setLastName',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setFirstName = createAction(
    'trains/order/setFirstName',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setPatronymic = createAction(
    'trains/order/setPatronymic',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setBirthDate = createAction(
    'trains/order/setBirthDate',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setEmailOrPhone = createAction(
    'trains/order/setEmailOrPhone',
    (payload: string, _meta: number) => payload.trim(),
    (payload: string, meta: number) => meta,
)();

export const setHasDiscountDocument = createAction(
    'trains/order/setHasDiscountDocument',
)<boolean, number>();
