import {createAction} from 'typesafe-actions';

import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {
    ADDITIONAL_REQUIREMENTS,
    ARRANGEMENT_REQUIREMENTS,
} from 'projects/trains/constants/requirements';

import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {
    CountRequirementsType,
    IAdditionalSchemeInfo,
    ITrainDetailsInfo,
    ITrainDirectionIndexPayload,
    ITrainsCoach,
    StoreyRequirementsType,
} from 'reducers/trains/order/types';
import {EPlacesView} from 'types/trains/booking/EPlacesView';

export const setOrderSegment = createAction('trains/order/setOrderSegment')<
    ITrainDirectionIndexPayload<TTrainsStoreOrderSegment>
>();

export const setTrainDetails = createAction('trains/order/setTrainDetails')<
    ITrainDirectionIndexPayload<ITrainDetailsInfo>
>();
export const clearTrainDetails = createAction(
    'trains/order/clearTrainDetails',
)<ITrainDirectionIndexPayload>();

export const clearSchemeFromCoaches = createAction(
    'trains/order/clearSchemeFromCoaches',
)<ITrainDirectionIndexPayload<number>>();

export const setCoach = createAction('trains/order/setCoach')<
    ITrainDirectionIndexPayload<ITrainsCoach | null>
>();

export const setPreferredGender = createAction(
    'trains/order/setPreferredGender',
)<ITrainDirectionIndexPayload<GENDER_TYPE | null>>();

export const setOrderCoachCategory = createAction(
    'trains/order/setOrderCoachCategory',
)<ITrainDirectionIndexPayload<string | null>>();

export const setOrderCoachType = createAction('trains/order/setOrderCoachType')<
    ITrainDirectionIndexPayload<TRAIN_COACH_TYPE | null>
>();

export const addPlacesToOrder = createAction('trains/order/addPlacesToOrder')<
    ITrainDirectionIndexPayload<number[]>
>();
export const removePlacesFromOrder = createAction(
    'trains/order/removePlacesFromOrder',
)<ITrainDirectionIndexPayload<number[]>>();
export const clearPlaces = createAction(
    'trains/order/clearPlaces',
)<ITrainDirectionIndexPayload>();
export const setPlaces = createAction('trains/order/setPlaces')<
    ITrainDirectionIndexPayload<number[]>
>();

export const setPlacesViewType = createAction('trains/order/setPlacesViewType')<
    ITrainDirectionIndexPayload<EPlacesView>
>();

export const clearRequirements = createAction(
    'trains/order/clearRequirements',
)<ITrainDirectionIndexPayload>();
export const clearCountRequirements = createAction(
    'trains/order/clearCountRequirements',
)<ITrainDirectionIndexPayload>();
export const setStoreyRequirements = createAction(
    'trains/order/setStoreyRequirements',
)<ITrainDirectionIndexPayload<StoreyRequirementsType>>();
export const setCountRequirements = createAction(
    'trains/order/setCountRequirements',
)<ITrainDirectionIndexPayload<CountRequirementsType>>();
export const setArrangementRequirements = createAction(
    'trains/order/setArrangementRequirements',
)<ITrainDirectionIndexPayload<ARRANGEMENT_REQUIREMENTS>>();
export const setAdditionalRequirements = createAction(
    'trains/order/setAdditionalRequirements',
)<ITrainDirectionIndexPayload<ADDITIONAL_REQUIREMENTS>>();

export const setBeddingOption = createAction('trains/order/setBeddingOption')<
    ITrainDirectionIndexPayload<boolean>
>();

export const setSchemeHasGroupedPlaces = createAction(
    'trains/order/schemeHasGroupedPlaces',
)<ITrainDirectionIndexPayload<IAdditionalSchemeInfo>>();

export const setExpandedServiceClass = createAction(
    'trains/order/setExpandedServiceClass',
)<ITrainDirectionIndexPayload<string | null>>();

export const setInitialExpandedServiceClass = createAction(
    'trains/order/setInitialExpandedServiceClass',
)<ITrainDirectionIndexPayload<string | null>>();

export const setProvider = createAction('trains/order/setProvider')<
    ITrainDirectionIndexPayload<string>
>();

export const setNonRefundableTariff = createAction(
    'trains/order/setNonRefundableTariff',
)<ITrainDirectionIndexPayload<boolean>>();
