import {createAction} from 'typesafe-actions';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {IOrderError} from 'reducers/trains/order/types';
import {EDirection} from 'types/common/EDirection';
import {TTrainApiOrderError} from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/TTrainOrderError/TTrainApiOrderError';
import {TTrainOrderError} from 'projects/trains/components/TrainsOrderApp/components/BookError/types';

export const setDirection = createAction(
    'trains/order/setDirection',
)<EDirection>();

export const setIndex = createAction('trains/order/setIndex')<number>();

export const setOrderStep = createAction(
    'trains/order/setOrderStep',
)<ORDER_STEP>();

/**
 * @deprecated - постепенно нужно перейти на setBookError с новой системой кодов ошибок
 */
export const setOrderError = createAction(
    'trains/order/setOrderError',
)<IOrderError | null>();

export const setBookError = createAction('trains/order/setBookError')<
    TTrainApiOrderError | TTrainOrderError | null
>();
