import {combineReducers} from 'redux';
import {getType} from 'typesafe-actions';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';
import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import {
    IOrderError,
    IStoreTrainTraveler,
    ITrainOrderContacts,
    ITrainPassenger,
    TrainsPassengersCount,
    ITrainCountrySelect,
    TTrainsOrderState,
} from 'reducers/trains/order/types';
import {EDirection} from 'types/common/EDirection';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import {TTrainApiOrderError} from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/TTrainOrderError/TTrainApiOrderError';
import {TTrainOrderError} from 'projects/trains/components/TrainsOrderApp/components/BookError/types';

import {ProjectAction} from 'reducers/storeTypes';
import contacts from 'reducers/trains/order/reducers/contacts';
import passengers from 'reducers/trains/order/reducers/passengers';
import passengersData from 'reducers/trains/order/reducers/passengersData';
import traveler from 'reducers/trains/order/reducers/traveler';
import {
    insuranceIncluded,
    previousCountOfPassengersWithPlaces,
    continueWithoutInsurance,
} from 'reducers/trains/order/reducers/userChoice';
import {
    orderInfo,
    availableCountries,
} from 'reducers/trains/order/reducers/data';
import {
    orderStep,
    orderError as error,
    bookError,
} from 'reducers/trains/order/reducers/view';
import {
    orderPageStatus,
    setPaymentCalled,
    paymentCompleted,
} from 'reducers/trains/order/reducers/flow';
import {resetOrder} from 'reducers/trains/order/actions/common';
import trains from 'reducers/trains/order/reducers/trains/trains';
import direction from 'reducers/trains/order/reducers/direction';
import index from 'reducers/trains/order/reducers/index';

export interface TrainsOrderStateInterface {
    direction: EDirection;
    index: number;
    trains: TTrainsOrderState;
    error: IOrderError | null;
    bookError: TTrainApiOrderError | TTrainOrderError | null;
    /**
     * Данные заполняются только на submit формы.
     * В будующем хочется совсем уйти от хранения данных формы в redux
     */
    contacts: ITrainOrderContacts;
    orderStep: ORDER_STEP;
    passengers: TrainsPassengersCount;
    orderInfo: IGenericOrderInfo | null;
    /**
     * Данные заполняются только на submit формы.
     * В будующем хочется совсем уйти от хранения данных формы в redux
     */
    passengersData: ITrainPassenger[];
    orderPageStatus: ORDER_PAGE_STATUSES;
    insuranceIncluded: boolean;
    availableCountries: ITrainCountrySelect[];
    paymentCompleted: boolean;
    continueWithoutInsurance: boolean;
    previousCountOfPassengersWithPlaces: number;
    traveler: IStoreTrainTraveler;
    isPaymentCalled: boolean;
}

const order = combineReducers<TrainsOrderStateInterface>({
    direction,
    index,
    trains,
    error,
    bookError,
    contacts,
    orderStep,
    passengers,
    orderInfo,
    passengersData,
    orderPageStatus,
    insuranceIncluded,
    availableCountries,
    paymentCompleted,
    continueWithoutInsurance,
    previousCountOfPassengersWithPlaces,
    traveler,
    isPaymentCalled: setPaymentCalled,
});

const DEFAULT_STATE = order(undefined, {type: ''});

export default function (
    state: TrainsOrderStateInterface = DEFAULT_STATE,
    action: ProjectAction,
): TrainsOrderStateInterface {
    if (action.type === getType(resetOrder)) {
        return DEFAULT_STATE;
    }

    return order(state, action);
}
