import {getType} from 'typesafe-actions';

import {PassengerBonusCardsType} from 'reducers/trains/order/types';

import {ProjectAction} from 'reducers/storeTypes';
import * as actions from 'reducers/trains/order/actions/bonusCards';

export const DEFAULT_STATE = {};

export default function bonusCards(
    state: PassengerBonusCardsType = DEFAULT_STATE,
    action: ProjectAction,
): PassengerBonusCardsType {
    switch (action.type) {
        case getType(actions.setBonusCard): {
            const {type, number} = action.payload;
            const newState = {...state};

            if (number) {
                newState[type] = {
                    ...newState[type],
                    value: number,
                };
            } else {
                delete newState[type];
            }

            return newState;
        }

        default:
            return state;
    }
}
