import {getType} from 'typesafe-actions';

import {ITrainOrderContacts} from 'reducers/trains/order/types';

import {ProjectAction} from 'reducers/storeTypes';
import * as actions from 'reducers/trains/order/actions/contacts';

const DEFAULT_STATE = {
    email: {value: ''},
    phone: {value: ''},
    useContacts: {value: true},
};

export default function contacts(
    state: ITrainOrderContacts = DEFAULT_STATE,
    action: ProjectAction,
): ITrainOrderContacts {
    switch (action.type) {
        case getType(actions.setOrderPhone):
            return {
                ...state,
                phone: {
                    value: action.payload,
                },
            };

        case getType(actions.setOrderEmail):
            return {
                ...state,
                email: {
                    value: action.payload,
                },
            };

        case getType(actions.setOrderUseContacts):
            return {
                ...state,
                useContacts: {
                    value: action.payload,
                },
            };

        default:
            return state;
    }
}
