import {getType} from 'typesafe-actions';

import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {
    ITrainCountrySelect,
    ITrainDetailsInfo,
    ITrainsCoach,
} from 'reducers/trains/order/types';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {ProjectAction} from 'reducers/storeTypes';
import * as actions from 'reducers/trains/order/actions/data';
import {
    clearSchemeFromCoaches,
    clearTrainDetails,
    setOrderSegment,
    setTrainDetails,
} from 'reducers/trains/order/actions/trains';

export const availableCountries = (
    state: ITrainCountrySelect[] = [],
    action: ProjectAction,
): ITrainCountrySelect[] =>
    action.type === getType(actions.setAvailableCountries)
        ? action.payload
        : state;

export const orderSegment = (
    state: TTrainsStoreOrderSegment | null = null,
    action: ProjectAction,
): TTrainsStoreOrderSegment | null =>
    action.type === getType(setOrderSegment) ? action.payload.data : state;

export const trainDetails = (
    state: ITrainDetailsInfo | null = null,
    action: ProjectAction,
): ITrainDetailsInfo | null => {
    switch (action.type) {
        case getType(clearTrainDetails): {
            return null;
        }

        case getType(setTrainDetails): {
            return action.payload.data;
        }

        case getType(clearSchemeFromCoaches): {
            if (!state?.trainDetails?.coaches?.length) {
                return state;
            }

            return {
                ...state,
                trainDetails: {
                    ...state.trainDetails,
                    coaches: state.trainDetails.coaches.map(
                        (coach: ITrainsCoach) =>
                            coach.schemaId === action.payload.data
                                ? {
                                      ...coach,
                                      schemaId: null,
                                  }
                                : coach,
                    ),
                },
            };
        }

        default: {
            return state;
        }
    }
};

export const orderInfo = (
    state: IGenericOrderInfo | null = null,
    action: ProjectAction,
): IGenericOrderInfo | null => {
    switch (action.type) {
        case getType(actions.setOrderInfo):
        case getType(actions.updateOrderInfo):
            return action.payload;
        case getType(actions.clearOrderInfo):
            return null;
        default:
            return state;
    }
};
