import {getType} from 'typesafe-actions';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import {ProjectAction} from 'reducers/storeTypes';

import * as actions from '../actions/flow';

export const orderPageStatus = (
    state: ORDER_PAGE_STATUSES = ORDER_PAGE_STATUSES.FETCHING_DATA,
    action: ProjectAction,
): ORDER_PAGE_STATUSES =>
    action.type === getType(actions.setOrderPageStatus)
        ? action.payload
        : state;

export const paymentCompleted = (
    state: boolean = false,
    action: ProjectAction,
): boolean =>
    action.type === getType(actions.setPaymentCompleted)
        ? action.payload
        : state;

export const setPaymentCalled = (
    state: boolean = false,
    action: ProjectAction,
): boolean =>
    action.type === getType(actions.setPaymentCalled) ? action.payload : state;
