import {createReducer} from 'typesafe-actions';

import {ProjectAction} from 'reducers/storeTypes';
import {setNonRefundableTariff} from 'reducers/trains/order/actions/trains';

export type TNonRefundableTariffState = boolean;

const INITIAL_STATE: TNonRefundableTariffState = false;

export default createReducer<TNonRefundableTariffState, ProjectAction>(
    INITIAL_STATE,
).handleAction(
    setNonRefundableTariff,
    (state, {payload}): TNonRefundableTariffState => payload.data,
);
