import {getType} from 'typesafe-actions';

import {ITrainOrderDocument} from 'reducers/trains/order/types';

import * as actions from 'reducers/trains/order/actions/passengerDocument';
import {ProjectAction} from 'reducers/storeTypes';

const DEFAULT_STATE = {
    type: {value: null},
    number: {value: ''},
    country: {value: null},
    validDate: {value: ''},
};

export default function passengerDocument(
    state: ITrainOrderDocument = DEFAULT_STATE,
    action: ProjectAction,
): ITrainOrderDocument {
    switch (action.type) {
        case getType(actions.setDocumentType):
            return {
                ...state,
                type: {
                    value: action.payload,
                },
            };

        case getType(actions.setDocumentNumber):
            return {
                ...state,
                number: {
                    value: action.payload,
                },
            };

        case getType(actions.setDocumentCountry):
            return {
                ...state,
                country: {
                    value: action.payload,
                },
            };

        case getType(actions.setDocumentValidDate):
            return {
                ...state,
                validDate: {
                    value: action.payload,
                },
            };

        default:
            return state;
    }
}
