import {getType} from 'typesafe-actions';

import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {TrainsPassengersCount} from 'reducers/trains/order/types';

import * as actions from 'reducers/trains/order/actions/passengers';
import {ProjectAction} from 'reducers/storeTypes';

export const PASSENGERS_DEFAULT_STATE = {
    [PASSENGERS_TYPES.ADULTS]: 1,
    [PASSENGERS_TYPES.CHILDREN]: 0,
    [PASSENGERS_TYPES.BABIES]: 0,
};

export default function passengers(
    state: TrainsPassengersCount = PASSENGERS_DEFAULT_STATE,
    action: ProjectAction,
): TrainsPassengersCount {
    switch (action.type) {
        case getType(actions.setCount[PASSENGERS_TYPES.ADULTS]):
            return {...state, adults: action.payload};
        case getType(actions.setCount[PASSENGERS_TYPES.CHILDREN]):
            return {...state, children: action.payload};
        case getType(actions.setCount[PASSENGERS_TYPES.BABIES]):
            return {...state, babies: action.payload};
        case getType(actions.resetTrainsPassengersCount):
            return PASSENGERS_DEFAULT_STATE;
        default:
            return state;
    }
}
