import {getType} from 'typesafe-actions';

import {
    ARRANGEMENT_REQUIREMENTS,
    REQUIREMENTS_IRRELEVANT_OPTION,
} from 'projects/trains/constants/requirements';

import {ITrainsRequirements} from 'reducers/trains/order/types';

import {ProjectAction} from 'reducers/storeTypes';
import {
    clearCountRequirements,
    clearRequirements,
    setAdditionalRequirements,
    setArrangementRequirements,
    setCountRequirements,
    setStoreyRequirements,
} from 'reducers/trains/order/actions/trains';

export const DEFAULT_REQUIREMENTS_STATE: ITrainsRequirements = {
    storey: REQUIREMENTS_IRRELEVANT_OPTION,
    arrangement: ARRANGEMENT_REQUIREMENTS.IRRELEVANT,
};

export default function requirements(
    state: ITrainsRequirements = DEFAULT_REQUIREMENTS_STATE,
    action: ProjectAction,
): ITrainsRequirements {
    switch (action.type) {
        case getType(clearRequirements):
            return DEFAULT_REQUIREMENTS_STATE;
        case getType(clearCountRequirements):
            return {
                ...state,
                count: undefined,
            };
        case getType(setCountRequirements):
            return {
                ...state,
                count: action.payload.data,
            };
        case getType(setStoreyRequirements):
            return {
                ...state,
                storey: action.payload.data,
            };
        case getType(setArrangementRequirements):
            return {
                ...state,
                arrangement: action.payload.data,
            };
        case getType(setAdditionalRequirements):
            return {
                ...state,
                additional: action.payload.data,
            };
        default:
            return state;
    }
}
