import {combineReducers} from 'redux';
import {getType} from 'typesafe-actions';

import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainOrderField, ITrainPassenger} from 'reducers/trains/order/types';

import {ProjectAction} from 'reducers/storeTypes';

import bonusCards from './bonusCards';
import passengerDocument from './passengerDocument';
import * as actions from '../actions/singlePassengerData';

const DEFAULT_FIELD_VALUE = {value: ''};

function ageGroup(
    state: PASSENGERS_TYPES = PASSENGERS_TYPES.ADULTS,
    action: ProjectAction,
): PASSENGERS_TYPES {
    if (action.type !== getType(actions.setAgeGroup)) {
        return state;
    }

    return action.payload;
}

function lastName(
    state: ITrainOrderField = DEFAULT_FIELD_VALUE,
    action: ProjectAction,
): ITrainOrderField {
    if (action.type === getType(actions.setLastName)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function firstName(
    state: ITrainOrderField = DEFAULT_FIELD_VALUE,
    action: ProjectAction,
): ITrainOrderField {
    if (action.type === getType(actions.setFirstName)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function patronymic(
    state: ITrainOrderField = DEFAULT_FIELD_VALUE,
    action: ProjectAction,
): ITrainOrderField {
    if (action.type === getType(actions.setPatronymic)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function birthDate(
    state: ITrainOrderField = DEFAULT_FIELD_VALUE,
    action: ProjectAction,
): ITrainOrderField {
    if (action.type === getType(actions.setBirthDate)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function gender(
    state: ITrainOrderField<GENDER_TYPE | null> = {value: null},
    action: ProjectAction,
): ITrainOrderField<GENDER_TYPE | null> {
    if (action.type === getType(actions.setGender)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function hasDiscountDocument(
    state: boolean = false,
    action: ProjectAction,
): boolean {
    if (action.type === getType(actions.setHasDiscountDocument)) {
        return action.payload;
    }

    return state;
}

function emailOrPhone(
    state: ITrainOrderField = DEFAULT_FIELD_VALUE,
    action: ProjectAction,
): ITrainOrderField {
    if (action.type === getType(actions.setEmailOrPhone)) {
        return {
            value: action.payload,
        };
    }

    return state;
}

function isNonRefundableTariff(state: boolean = false): boolean {
    return state;
}

export const singlePassengerData = combineReducers<ITrainPassenger>({
    firstName,
    lastName,
    patronymic,
    birthDate,
    gender,
    hasDiscountDocument,
    passengerDocument,
    bonusCards,
    ageGroup,
    emailOrPhone,
    isNonRefundableTariff,
});
