import {ITrainOrderState} from 'reducers/trains/order/types';
import {EPlacesView} from 'types/trains/booking/EPlacesView';

import {ProjectAction} from 'reducers/storeTypes';
import requirements, {
    DEFAULT_REQUIREMENTS_STATE,
} from 'reducers/trains/order/reducers/requirements';
import {
    coach,
    orderPlaces,
    beddingOption,
    orderCoachType as coachType,
    preferredGender as gender,
    orderCoachCategory as coachCategory,
} from 'reducers/trains/order/reducers/userChoice';
import {
    trainDetails,
    orderSegment as segment,
} from 'reducers/trains/order/reducers/data';
import {
    placesViewType,
    expandedServiceClass,
    initialExpandedServiceClass,
    additionalSchemeInfo,
} from 'reducers/trains/order/reducers/view';
import provider from 'reducers/trains/order/reducers/provider';
import nonRefundableTariff from 'reducers/trains/order/reducers/nonRefundableTariff';

const initialState: ITrainOrderState = {
    segment: null,
    coach: null,
    gender: null,
    coachCategory: null,
    coachType: null,
    orderPlaces: [],
    placesViewType: EPlacesView.SCHEMAS,
    trainDetails: null,
    requirements: DEFAULT_REQUIREMENTS_STATE,
    beddingOption: true,
    additionalSchemeInfo: [],
    expandedServiceClass: null,
    initialExpandedServiceClass: null,
    provider: null,
    nonRefundableTariff: false,
};

export default function train(
    state: ITrainOrderState = initialState,
    action: ProjectAction,
): ITrainOrderState {
    return {
        segment: segment(state.segment, action),
        coach: coach(state.coach, action),
        gender: gender(state.gender, action),
        coachCategory: coachCategory(state.coachCategory, action),
        coachType: coachType(state.coachType, action),
        orderPlaces: orderPlaces(state.orderPlaces, action),
        placesViewType: placesViewType(state.placesViewType, action),
        trainDetails: trainDetails(state.trainDetails, action),
        requirements: requirements(state.requirements, action),
        beddingOption: beddingOption(state.beddingOption, action),
        additionalSchemeInfo: additionalSchemeInfo(
            state.additionalSchemeInfo,
            action,
        ),
        expandedServiceClass: expandedServiceClass(
            state.expandedServiceClass,
            action,
        ),
        initialExpandedServiceClass: initialExpandedServiceClass(
            state.initialExpandedServiceClass,
            action,
        ),
        provider: provider(state.provider, action),
        nonRefundableTariff: nonRefundableTariff(
            state.nonRefundableTariff,
            action,
        ),
    };
}
