import {
    isTrainDirectionIndexPayload,
    TTrainsOrderState,
} from 'reducers/trains/order/types';
import {EDirection} from 'types/common/EDirection';

import {ProjectAction} from 'reducers/storeTypes';
import train from 'reducers/trains/order/reducers/trains/train';

export const initialState: TTrainsOrderState = {
    [EDirection.FORWARD]: {},
    [EDirection.BACKWARD]: {},
};

export default function trains(
    state: TTrainsOrderState = initialState,
    action: ProjectAction,
): TTrainsOrderState {
    if (
        !('payload' in action) ||
        !isTrainDirectionIndexPayload(action.payload)
    ) {
        return state;
    }

    const {direction, index} = action.payload;

    return {
        ...state,
        [direction]: {
            ...state[direction],
            [index]: train(state[direction][index], action),
        },
    };
}
