import {getType} from 'typesafe-actions';

import {IStoreTrainTraveler} from 'reducers/trains/order/types';

import * as actions from 'reducers/trains/order/actions/traveler';
import {ProjectAction} from 'reducers/storeTypes';

const DEFAULT_STATE: IStoreTrainTraveler = {
    accountPassengers: [],
    passengers: [],
};

export default function traveler(
    state = DEFAULT_STATE,
    action: ProjectAction,
): IStoreTrainTraveler {
    switch (action.type) {
        case getType(actions.setTravelerPassengers):
            return {
                ...state,
                passengers: action.payload,
            };

        case getType(actions.setTravelerAccountPassengers):
            return {
                ...state,
                accountPassengers: action.payload,
            };

        case getType(actions.setTravelerDocumentClickedState): {
            const {passengerId, documentIndex} = action.payload;

            const passengerIndex = state.passengers.findIndex(
                ({id}) => id === passengerId,
            );
            const passenger = state.passengers[passengerIndex];

            return {
                ...state,
                passengers: [
                    ...state.passengers.slice(0, passengerIndex),
                    {
                        ...passenger,
                        documents: [
                            ...passenger.documents.slice(0, documentIndex),
                            {
                                ...passenger.documents[documentIndex],
                                clicked: true,
                            },
                            ...passenger.documents.slice(documentIndex + 1),
                        ],
                    },
                    ...state.passengers.slice(passengerIndex + 1),
                ],
            };
        }

        default:
            return state;
    }
}
