import {getType} from 'typesafe-actions';
import union from 'lodash/union';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach} from 'reducers/trains/order/types';

import {ProjectAction} from 'reducers/storeTypes';
import * as actions from 'reducers/trains/order/actions/userChoice';
import {
    addPlacesToOrder,
    clearPlaces,
    clearSchemeFromCoaches,
    removePlacesFromOrder,
    setBeddingOption,
    setCoach,
    setOrderCoachCategory,
    setOrderCoachType,
    setPlaces,
    setPreferredGender,
} from 'reducers/trains/order/actions/trains';

export const orderCoachType = (
    state: TRAIN_COACH_TYPE | null = null,
    action: ProjectAction,
): TRAIN_COACH_TYPE | null =>
    action.type === getType(setOrderCoachType) ? action.payload.data : state;

export const preferredGender = (
    state: GENDER_TYPE | null = null,
    action: ProjectAction,
): GENDER_TYPE | null =>
    action.type === getType(setPreferredGender) ? action.payload.data : state;

export const insuranceIncluded = (
    state: boolean = false,
    action: ProjectAction,
): boolean =>
    action.type === getType(actions.setInsuranceIncluded)
        ? action.payload
        : state;

export const continueWithoutInsurance = (
    state: boolean = false,
    action: ProjectAction,
): boolean =>
    action.type === getType(actions.setContinueWithoutInsurance)
        ? action.payload
        : state;

export const orderCoachCategory = (
    state: string | null = null,
    action: ProjectAction,
): string | null =>
    action.type === getType(setOrderCoachCategory)
        ? action.payload.data
        : state;

export const coach = (
    state: ITrainsCoach | null = null,
    action: ProjectAction,
): ITrainsCoach | null => {
    if (action.type === getType(setCoach)) {
        return action.payload.data;
    }

    if (
        state &&
        action.type === getType(clearSchemeFromCoaches) &&
        state.schemaId === action.payload.data
    ) {
        return {
            ...state,
            schemaId: null,
        };
    }

    return state;
};

export const beddingOption = (
    state: boolean = true,
    action: ProjectAction,
): boolean =>
    action.type === getType(setBeddingOption) ? action.payload.data : state;

export const previousCountOfPassengersWithPlaces = (
    state: number = 0,
    action: ProjectAction,
): number =>
    action.type === getType(actions.setPreviousCountOfPassengersWithPlaces)
        ? action.payload
        : state;

export const orderPlaces = (
    state: number[] = [],
    action: ProjectAction,
): number[] => {
    switch (action.type) {
        case getType(addPlacesToOrder):
            return union(state, action.payload.data).sort((a, b) => a - b);
        case getType(removePlacesFromOrder):
            return state.filter(
                number => !action.payload.data.includes(number),
            );
        case getType(setPlaces):
            return [...action.payload.data].sort((a, b) => a - b);
        case getType(clearPlaces):
            return [];
        default:
            return state;
    }
};
