import {getType} from 'typesafe-actions';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {IAdditionalSchemeInfo, IOrderError} from 'reducers/trains/order/types';
import {EPlacesView} from 'types/trains/booking/EPlacesView';
import {TTrainApiOrderError} from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/TTrainOrderError/TTrainApiOrderError';
import {TTrainOrderError} from 'projects/trains/components/TrainsOrderApp/components/BookError/types';

import {ProjectAction} from 'reducers/storeTypes';
import * as actions from 'reducers/trains/order/actions/view';
import {
    clearTrainDetails,
    setExpandedServiceClass,
    setInitialExpandedServiceClass,
    setPlacesViewType,
    setSchemeHasGroupedPlaces,
    setTrainDetails,
} from 'reducers/trains/order/actions/trains';

export const orderStep = (
    state: ORDER_STEP = ORDER_STEP.PLACES,
    action: ProjectAction,
): ORDER_STEP =>
    action.type === getType(actions.setOrderStep) ? action.payload : state;

export const orderError = (
    state: IOrderError | null = null,
    action: ProjectAction,
): IOrderError | null =>
    action.type === getType(actions.setOrderError) ? action.payload : state;

export const bookError = (
    state: TTrainApiOrderError | TTrainOrderError | null = null,
    action: ProjectAction,
): TTrainApiOrderError | TTrainOrderError | null =>
    action.type === getType(actions.setBookError) ? action.payload : state;

export const placesViewType = (
    state: EPlacesView = EPlacesView.SCHEMAS,
    action: ProjectAction,
): EPlacesView =>
    action.type === getType(setPlacesViewType) ? action.payload.data : state;

export const expandedServiceClass = (
    state: string | null = null,
    action: ProjectAction,
): string | null =>
    action.type === getType(setExpandedServiceClass)
        ? action.payload.data
        : state;

export const initialExpandedServiceClass = (
    state: string | null = null,
    action: ProjectAction,
): string | null =>
    action.type === getType(setInitialExpandedServiceClass)
        ? action.payload.data
        : state;

export const additionalSchemeInfo = (
    state: IAdditionalSchemeInfo[] = [],
    action: ProjectAction,
): IAdditionalSchemeInfo[] => {
    if (
        action.type === getType(setTrainDetails) ||
        action.type === getType(clearTrainDetails)
    ) {
        return [];
    }

    if (action.type === getType(setSchemeHasGroupedPlaces)) {
        const newState = [...state];
        const index = newState.findIndex(
            value => value.index === action.payload.data.index,
        );

        if (index > -1) {
            newState.splice(index, 1, action.payload.data);

            return newState;
        }

        return [...newState, action.payload.data];
    }

    return state;
};
