import {batchActions} from 'redux-batched-actions';

import {ITrainsCoach} from 'reducers/trains/order/types';

import {setCoachCategoryAndInitialCoach} from 'reducers/trains/order/thunk/setCoachCategoryAndInitialCoach';
import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    clearPlaces,
    clearRequirements,
    setPreferredGender,
} from 'reducers/trains/order/actions/trains';

import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

/*
 * Обработчик изменения вагона
 */
export function changeCoach(coach: ITrainsCoach): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {direction, index} = currentSegmentDirectionAndIndexSelector(
            getState(),
        );

        dispatch(
            batchActions([
                setPreferredGender({direction, index, data: null}),
                clearPlaces({direction, index, data: undefined}),
                clearRequirements({direction, index, data: undefined}),
            ]),
        );

        dispatch(
            setCoachCategoryAndInitialCoach({
                categoryOrType: coach.category.value,
                schemeHasGroupedPlaces: false,
                coach,
                direction,
                index,
            }),
        );
    };
}
