import {batchActions} from 'redux-batched-actions';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {setCoachCategoryAndInitialCoach} from 'reducers/trains/order/thunk/setCoachCategoryAndInitialCoach';
import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    clearPlaces,
    clearRequirements,
    setPreferredGender,
} from 'reducers/trains/order/actions/trains';

/*
 * Обработчик изменения категории вагона
 */
export function changeCoachType(
    coachType: TRAIN_COACH_TYPE | null,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            trains: {
                order: {direction, index},
            },
        } = getState();

        dispatch(
            batchActions([
                setPreferredGender({direction, index, data: null}),
                clearPlaces({direction, index, data: undefined}),
                clearRequirements({direction, index, data: undefined}),
            ]),
        );

        dispatch(
            setCoachCategoryAndInitialCoach({
                categoryOrType: coachType,
                schemeHasGroupedPlaces: false,
                coach: null,
                direction,
                index,
            }),
        );
    };
}
